/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RenderUtils {
    public static void bindBlockTexture() {
        Minecraft.m_91087_().f_90987_.m_174784_(TextureAtlas.f_118259_);
    }

    public static TextureAtlasSprite getStillTexture(FluidStack fluidstack) {
        return RenderUtils.getStillTexture(fluidstack.getFluid());
    }

    public static TextureAtlasSprite getStillTexture(Fluid fluid) {
        ResourceLocation iconKey = fluid.getAttributes().getStillTexture();
        if (iconKey == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(iconKey);
    }

    public static void renderGuiTank(FluidTank tank, double x, double y, double zLevel, double width, double height) {
        RenderUtils.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public static void renderGuiTank(FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.getAmount() <= 0) {
            return;
        }
        TextureAtlasSprite icon = null;
        if (RenderUtils.getStillTexture(fluid) == null) {
            return;
        }
        icon = RenderUtils.getStillTexture(fluid);
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderUtils.setGLColorFromInt(color);
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                float minU = icon.m_118409_();
                float maxU = icon.m_118410_();
                float minV = icon.m_118411_();
                float maxV = icon.m_118412_();
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder buf = tessellator.m_85915_();
                buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buf.m_5483_((double)drawX, (double)(drawY + drawHeight), 0.0).m_7421_(minU, minV + (maxV - minV) * (float)drawHeight / 16.0f).m_5752_();
                buf.m_5483_((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).m_7421_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV + (maxV - minV) * (float)drawHeight / 16.0f).m_5752_();
                buf.m_5483_((double)(drawX + drawWidth), (double)drawY, 0.0).m_7421_(minU + (maxU - minU) * (float)drawWidth / 16.0f, minV).m_5752_();
                buf.m_5483_((double)drawX, (double)drawY, 0.0).m_7421_(minU, minV).m_5752_();
                tessellator.m_85914_();
            }
            i += 16;
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

